IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='VENDAS_PROCESSADAS_CRM_BONUS')
			 
BEGIN
	CREATE TABLE [dbo].[VENDAS_PROCESSADAS_CRM_BONUS](
		[CD_EMP] [int] NOT NULL DEFAULT 0,
		[CD_FILIAL] [int] NOT NULL DEFAULT 0,
		[CD_VD] [bigint] NOT NULL DEFAULT 0,
		[ST_VD] [int] NOT NULL DEFAULT 0,
		[STS_ENVIO_CRM_BONUS] [int] NOT NULL DEFAULT 0,
		[DT_PROCESSAMENTO] DATETIME DEFAULT CAST(GETDATE() AS DATE)
	 CONSTRAINT [PK_VENDAS_PROCESSADAS_CRM_BONUS] PRIMARY KEY CLUSTERED 
	(	[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_VD] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
END


IF NOT EXISTS (
		SELECT *
		FROM sys.indexes
		WHERE object_id = OBJECT_ID(N'[dbo].[VENDAS_PROCESSADAS_CRM_BONUS]')
			AND name = N'IX_VENDAS_PROCESSADAS_CRM_BONUS_STATUS'
		)
BEGIN
	CREATE NONCLUSTERED INDEX [IX_VENDAS_PROCESSADAS_CRM_BONUS_STATUS] ON [dbo].[VENDAS_PROCESSADAS_CRM_BONUS](
        [ST_VD],
        [STS_ENVIO_CRM_BONUS],
        [DT_PROCESSAMENTO]
    )
    WITH (
        STATISTICS_NORECOMPUTE = OFF,
        SORT_IN_TEMPDB = ON,
        PAD_INDEX = OFF,
        FILLFACTOR = 80
    ) ON [PRIMARY];
END